1 REM:PROGRAM NAME = JETSET
2 REM:IFR FLIGHT SIMULATOR (BOEING 747)
3 REM:CREATED 06/28/81 BY JEAN SZYMANSKI
4 REM:REVISED 02/25/82 - INSTRUCTIONS IN NOVEMBER 1982 'BYTE MAGAZINE'
9 REM:SYSTEM "CLOCK OFF"
10 GOTO 10000
23 REM:BEGIN CRUISE MODULE HERE
24 CLS:CLEAR 2000:RANDOMIZE 57.2958
25 DIM M$(20)
26 KR=57.2958:XQ=64
27 RS=1:IF RND(0)<.5 THEN RS=-1
28 RW=(15-5)*RND(0)+5
29 RW=RS*RW
30 REM:SET UP WIND TABLE
32 DIM WA(10,1)
34 FOR I=0 TO 7:WA(I,0)=RND(359):NEXT
36 FOR I=8 TO 10:WA(I,0)=90*RND(0)+225:NEXT
38 A=0
40 FOR I=1 TO 10:WA(I,1)=25*RND(0)+A:A=A+25:NEXT
41 RS$(0)=STRING$(31,"_")
42 RS$(1)=SPACE$(13)+".   ."+SPACE$(13)
43 RS$(2)=SPACE$(11)+".       ."
44 RS$(3)=SPACE$(9)+STRING$(13,"_")
45 REM:VOR STATION FREQUENCY TABLE
46 DIM VF(15)
47 VF(0)=115.9:VF(1)=113.8:VF(2)=112.7
48 VF(3)=117.7:VF(4)=117.8:VF(5)=112.2
49 VF(6)=117.4:VF(7)=115.5:VF(8)=116.4
50 VF(9)=113.6:VF(10)=116.9:VF(11)=117!
51 VF(12)=112.3:VF(13)=117.9:VF(14)=115.7
52 VF(15)=112.8
62 REM:ILS CONSTANTS FOR AIRPORTS
63 DIM VG(15,1)
64 VG(0,0)=238:VG(0,1)=28
66 VG(2,0)=240:VG(2,1)=30
69 VG(5,0)=90:VG(5,1)=217
71 VG(7,0)=299:VG(7,1)=164
72 VG(8,0)=166:VG(8,1)=42
79 VG(15,0)=341:VG(15,1)=75
100 REM:VOR STATION COORDIATES TABLE
101 DIM VP(15,1)
102 VP(0,0)=40.633:VP(0,1)=73.773
103 VP(1,0)=40.202:VP(1,1)=74.495
104 VP(2,0)=42.358:VP(2,1)=70.993
105 VP(3,0)=41.282:VP(3,1)=70.027
106 VP(4,0)=42.74301:VP(4,1)=73.802
107 VP(5,0)=46.412:VP(5,1)=84.315
108 VP(6,0)=38.35:VP(6,1)=81.77001
109 VP(7,0)=40.917:VP(7,1)=77.993
110 VP(8,0)=42.928:VP(8,1)=78.67401
111 VP(9,0)=41.358:VP(9,1)=82.162
112 VP(10,0)=42.967:VP(10,1)=83.72401
113 VP(11,0)=44.555:VP(11,1)=88.19501
114 VP(12,0)=41.547:VP(12,1)=88.318
115 VP(13,0)=39.495:VP(13,1)=76.97801
116 VP(14,0)=42.048:VP(14,1)=83.458
117 VP(15,0)=39.637:VP(15,1)=75.303
155 DATA FUEL,LBS,%,VHF,MHZ,THRUST,MAX,IDLE,REV
160 DATA PITCH," +"," -",DEG,FLAPS,UP,DWN,WHEELS,UP,MID,DOWN
165 DATA COMPASS,AIRSPEED,KTS," VERT",SPEED,FPM
170 DATA ALTITUDE,FEET,CLOCK
175 DIM P$(28)
180 FOR I=0 TO 28:READ P$(I):NEXT
185 DIM S$(25)
190 FOR I=1 TO 25:S$(I)=SPACE$(I):NEXT
192 FOR I=0 TO 9:F(I)=0:NEXT
195 REM:INIT FLIGHT VARIABLES TO STATE AT LIFTOFF
196 FU=195480!:FP=63:CC=75:ZS=380:RC=6704:AL=1900
198 MZ=122:TR=4:FL=1:FA=10:BR=10:WH=10
200 RA=0:ZS(1)=380:FA(1)=10:CC(1)=75:AL(1)=1900:RP=40
201 DP(4)=39:DP(5)=52:DP(6)=75:DP(7)=15
202 L1=39.8667:G1=75.25:LL(1)=L1:GL(1)=G1:LS(1)=L1:GS(1)=G1
203 VO(1)=0:VO$(1)="OUT ":VO(3)=0:VO(4)=999.9
204 GX(0)=0:GY(0)=0
205 XO=36481!:YO=0
220 TV$=TIME$:GOSUB 7050:TL=TD
221 TW(1)=TD
222 GOSUB 335
224 GOSUB 600
300 K$=INKEY$:IF LEN(K$)=0 GOTO 304
302 GOSUB 800
304 GOTO 1000
335 REM:DISPLAY PANEL (HEADERS ONLY)
340 LOCATE 1,4:PRINT P$(0);S$(4);P$(5);S$(3);P$(9);S$(3);S$(6);S$(3);P$(20)
341 LOCATE 10,55:PRINT P$(13);S$(3);P$(16)
342 LOCATE 11,57:PRINT P$(14);S$(6);P$(14)
343 LOCATE 13,57:PRINT P$(15);S$(5);P$(15)
345 LOCATE 2,14:PRINT P$(6);S$(6);P$(10);S$(6)
350 LOCATE 2,69:PRINT P$(28)
355 LOCATE 3,2:PRINT P$(1);S$(4);P$(2);S$(21);S$(3);S$(13);P$(23)
360 LOCATE 4,23:PRINT P$(11);S$(13);P$(21);S$(2);P$(24);S$(2);P$(26)
365 LOCATE 5,1:PRINT P$(3)
370 LOCATE 6,40:PRINT P$(22);S$(6);P$(25);S$(5);P$(27)
375 LOCATE 7,1:PRINT P$(4);S$(10);P$(7);S$(3);P$(12);S$(7)
380 LOCATE 8,14:PRINT P$(8)
381 LOCATE 4,69:PRINT"VLF OMEGA":LOCATE 5,66:PRINT"LAT"
382 LOCATE 6,65:PRINT"LONG"
383 LOCATE 7,33:PRINT". . . . : . . . .":LOCATE 9,40:PRINT"RUD"
384 LOCATE 10,33:PRINT CHR$(201);STRING$(15,205);CHR$(187)
386 FOR X = 32 TO 48 STEP 16
387 FOR Y = 10 TO 22
388 LOCATE (Y+1),(X+1):PRINT CHR$(186);
389 NEXT Y
390 NEXT X
391 LOCATE 24,33:PRINT CHR$(200);STRING$(15,205);CHR$(188);
392 LOCATE 11,40:PRINT"VOR":LOCATE 12,45:PRINT"MHZ"
393 LOCATE 15,39:PRINT"RANGE"
394 LOCATE 17,36:PRINT".....:....."
395 LOCATE 20,39:PRINT"RADIAL"
396 LOCATE 22,40:PRINT"DME":LOCATE 23,45:PRINT"NM";
397 FOR Y = 1 TO 7:LOCATE (Y+1),13:PRINT CHR$(195):NEXT
398 FOR Y = 1 TO 3:LOCATE (Y+1),22:PRINT CHR$(195):NEXT
400 LOCATE 15,1:PRINT CHR$(201);STRING$(15,205);CHR$(187)
402 FOR X = 0 TO 16 STEP 16
404 FOR Y = 15 TO 21
406 LOCATE (Y+1),(X+1):PRINT CHR$(186);
408 NEXT Y
410 NEXT X
412 LOCATE 23,1:PRINT CHR$(200);STRING$(15,205);CHR$(188);
414 LOCATE 14,8:PRINT"ILS"
416 LOCATE 18,20:PRINT"MARKER":LOCATE 19,21:PRINT">  <"
418 GX(1)=0:GY(1)=0
420 GOSUB 2100
422 COLOR 0,7:LOCATE 11,8:PRINT"     "
424 COLOR 7,0:LOCATE 10,5:PRINT"RADAR ALT";SPC(6);"STALL"
425 LOCATE 11,19:PRINT">     <"
599 RETURN
600 REM:DISPLAY INSTRUMENT READINGS
601 GOTO 720
605 YP=1:XP=0:F$="######":V1=FU:GOSUB 9000
606 LOCATE 1,67:COLOR 0,7:PRINT TIME$:COLOR 7,0
610 YP=1:XP=7:F$="###":V1=FP:GOSUB 9000
615 YP=1:XP=39:V1=CC:GOSUB 9000
620 YP=4:XP=39:V1=ZS:GOSUB 9000
625 YP=4:XP=46:F$="######":V1=RC:GOSUB 9000
630 YP=4:XP=55:F$="##,###":V1=AL:GOSUB 9000
635 YP=5:XP=0:F$="###":V1=MZ:GOSUB 9000
636 IF F(2)=1 THEN YP=10:XP=6:F$="#####":V1=AL:GOSUB 9000
640 REM:DISPLAY THRUST
650 FOR I = 1 TO 7
651 LOCATE (I+1),12:PRINT" ";CHR$(195)
652 NEXT
655 LOCATE (TR+1),12:PRINT">";
660 REM:DISPLAY FLAPS
665 FOR I = 1 TO 3:LOCATE (I+1),21:PRINT" ";CHR$(195):NEXT
670 LOCATE (FL+1),21:PRINT">"
674 F$="+###"
675 YP=5:XP=20:V1=FA:GOSUB 9000
676 IF F(6)=0 THEN SX=25:COLOR 7,0:GOTO 679
677 IF SX=25 THEN SX=26:COLOR 0,7:GOTO 679
678 SX=25
679 IF F(7)=0 THEN LOCATE 11,20:PRINT"     ":COLOR 7,0
680 REM:DISPLAY BRAKES
690 FOR I=10 TO 12:LOCATE (I+1),55:PRINT" ";CHR$(195):NEXT
695 LOCATE (BR+1),55:PRINT">"
700 REM:WHEELS
705 FOR I=10 TO 12:LOCATE (I+1),63:PRINT" ";CHR$(195):NEXT
710 LOCATE (WH+1),63:PRINT">"
711 IF F(2)=1 GOTO 723
712 REM:DISPLAY LAT/LONGDITUDE
713 YP=4:XP=69:F$="###":V1=DP(4):GOSUB 9000
714 YP=4:XP=73:F$="##.#":V1=DP(5):GOSUB 9000
715 YP=5:XP=69:F$="###":V1=DP(6):GOSUB 9000
716 YP=5:XP=73:F$="##.#":V1=DP(7):GOSUB 9000
717 LOCATE 5,79:PRINT"N"
718 LOCATE 6,79:PRINT"W"
719 GOTO 723
720 REM:DISPLAY RUDDER POSITION
721 LOCATE 8,33:COLOR 0,7:PRINT S$(17)
722 LOCATE 8,(RP+1):PRINT CHR$(186):COLOR 7,0:GOTO 605
723 IF F(2)=1 THEN RETURN
724 REM:DISPLAY VOR VALUES
725 YP=11:XP=38:F$="###.#":V1=VO(1):GOSUB 9000
726 COLOR 0,7:LOCATE 14,40:PRINT VO$(1):COLOR 7,0
727 YP=18:XP=39:F$="###":V1=VO(3):GOSUB 9000
728 YP=22:XP=38:F$="###.#":V1=VO(4):GOSUB 9000
729 COLOR 0,7:LOCATE 18,35:PRINT S$(13):COLOR 7,0
730 IF VO$(1)="OUT " GOTO 732
731 LOCATE 18,(VO(2)+1):PRINT CHR$(24)
732 RETURN
800 REM:KEY POLL SUBROUT
805 IF K$="F" OR K$="S" THEN KK=1:GOTO 850
810 IF K$="," OR K$="." THEN KK=2:GOTO 850
811 IF K$="/" THEN RA=0:GOTO 855
825 IF K$="U" OR K$="D" THEN KK=3:GOTO 850
830 IF K$="W" THEN KK=4:GOTO 850
835 IF K$="V" THEN KK=5:GOTO 850
836 IF K$="R" THEN KK=6:GOTO 850
837 IF K$="L" THEN KK=7:GOTO 850
838 IF K$="A" THEN KK=8:GOTO 850
839 IF K$="Q" THEN KK=9:GOTO 850
840 IF K$="M" THEN KK=10:GOTO 850
841 IF K$="C" THEN KK=11:GOTO 850
850 ON KK GOSUB 900,908,914,928,931,935,940,944,946,950,953
855 RETURN
900 REM:THRUST KEY
902 IF K$="F" THEN TR=TR-1 ELSE TR=TR+1
904 IF TR<1 THEN TR=1:RETURN
908 REM:RUDDER KEYS
909 IF K$="," GOTO 912 ELSE RA=RA+1
910 IF RA>4 THEN RA=4
911 RETURN
912 RA=RA-1:IF RA<-4 THEN RA=-4
913 RETURN
914 REM:ELEVATOR KEYS
915 J=5:IF BR=12 THEN J=1
916 IF K$="U" THEN FA=FA+J ELSE FA=FA-J
918 IF FA>40 THEN FA=40
920 IF FA<-40 THEN FA=-40
922 IF FA>0 THEN FL=1:RETURN
924 IF FA=0 THEN FL=2:RETURN
926 FL=3:RETURN
928 REM:WHEELS KEY
929 IF WH=10 THEN WH=12:RETURN
930 IF WH=12 THEN WH=10:RETURN
931 REM:SET VOR FREQ
932 LOCATE 15,56
933 LINE INPUT"VOR FREQ ";VX$:VO(1)=VAL(VX$)
934 LOCATE 15,56:PRINT SPC(16):RETURN
935 REM:SET VOR RADIAL
936 LOCATE 15,56
937 LINE INPUT"VOR RADIAL ";VX$:VO(3)=VAL(VX$)
938 LOCATE 15,56:PRINT SPC(14):RETURN
940 REM:FLAPS KEY
941 IF BR=10 THEN BR=12:RETURN
942 IF BR=12 THEN BR=10:RETURN
944 REM:AUTO - OBS KEY
945 F(3)=1:RETURN
946 REM:REVERSE THRUST KEY
947 IF F(7)=1 THEN TR=7
948 RETURN
950 REM:MISSED APPROACH KEY
951 IF F(2)=1 THEN F(5)=1
952 RETURN
953 REM:FLARE KEY
954 IF F(2)=0 THEN FA=0:FL=2:RETURN
955 FA=1:FL=1:RETURN
1000 REM:SITUATION UPDATE ROUTINE
1002 TV$=TIME$:GOSUB 7050:TJ=TD-TL:TL=TD
1010 GOSUB 1100
1012 GOSUB 1130
1013 GOSUB 1145
1014 IF TR=7 THEN GOSUB 1800 ELSE GOSUB 1124
1016 GOSUB 1106
1018 GOSUB 1114
1019 IF F(2)=1 GOTO 1600
1020 GOSUB 1400
1021 GOSUB 1500
1030 IF AL<=0 THEN AF=1:GOTO 3000
1031 IF F(2)=0 GOTO 1099
1032 IF AL>0 GOTO 1068
1033 IF F(7)=1 GOTO 1090
1034 F(7)=1
1036 TY=YN
1038 TX=XN-750
1042 IF FA>1 THEN AF=2:GOTO 3000
1044 IF FA<0 THEN AF=3:GOTO 3000
1046 IF F(6)=0 GOTO 1062
1048 IF AX>100 THEN AF=4:GOTO 3000
1050 IF AX>80 THEN AF=5:GOTO 3000
1052 IF WH=10 THEN AF=6:GOTO 3000
1054 IF TX>0 THEN AF=7:GOTO 3000
1056 IF TX<-10500 THEN AF=7:GOTO 3000
1058 IF ABS(TY)>100 THEN AF=7:GOTO 3000
1060 GOTO 1099
1062 AF=8:GOTO 3000
1068 IF F(5)=1 GOTO 1082
1070 IF FA>0 GOTO 1076
1072 IF FA<0 THEN F(6)=0
1074 GOTO 1099
1076 IF F(6)=0 THEN AX=AL:F(6)=1
1077 IF TR=6 GOTO 1080
1078 IF FA<2 THEN RC=-1800:GOTO 1099
1079 FA=2:FL=1:RC=-1800:GOTO 1099
1080 FA=1:FL=1:RC=-300:GOTO 1099
1082 IF AL<20 THEN AF=9:GOTO 3000
1084 TR=3:FA=0:FL=2
1086 AF=10:GOTO 3000
1090 IF XN<-9750 OR ABS(YN)>100 GOTO 1094
1091 IF ZS>0 GOTO 1099
1092 AF=0:GOTO 3000
1094 AF=9:GOTO 3000
1099 GOTO 1700
1100 REM:UPDATE FUEL
1102 FU=FU-(14-TR)*TJ:IF FU<0 THEN FU=0
1104 FP=FU/3120:RETURN
1106 IF F(7)=1 THEN RC=0:RETURN
1107 IF F(6)=1 THEN RETURN
1108 RC=ZS*SIN(ABS(FA/KR))*101.6
1110 IF FA<0 THEN RC=-1*RC
1112 RETURN
1114 REM:UPDATE ALTITUDE
1115 IF F(7)=1 THEN RETURN
1116 AL=AL+TJ*RC/60
1118 IF AL<0 THEN AL=0:RETURN
1120 IF AL>45000! THEN AL=45000!
1122 RETURN
1124 REM:UPDATE AIRSPEED
1125 ZS=800-100*TR
1126 ZS=ZS-2*FA
1127 IF BR=10 THEN RETURN
1128 ZS=ZS/3+20:RETURN
1130 IF F(5)=1 GOTO 1132
1131 IF F(2)=1 GOTO 1142
1132 IF RA=0 THEN RT=0:RETURN
1133 IF RA<0 THEN J=-1 ELSE J=1
1134 RA=ABS(RA):IF RA=1 THEN RT=1:GOTO 1137
1135 IF RA=2 THEN RT=10:GOTO 1137
1136 IF RA=3 THEN RT=20 ELSE RT=30
1137 RT=J*RT:RA=J*RA
1138 CC=CC+RT
1139 IF CC=>360 THEN CC=CC-360:RETURN
1140 IF CC<0 THEN CC=360+CC
1141 RETURN
1142 IF RA=0 THEN RETURN
1143 IF RA<0 THEN CC=CC-1 ELSE CC=CC+1
1144 RA=0:GOTO 1139
1145 REM:UPDATE RUDDER POSITION VALUE
1146 RP=40+RA+RA:RETURN
1200 REM:COMPUTES DIST & BEARING TO A KNOWN POINT LOCATION
1202 VL=ABS(LB-LC):BL(5)=-1:IF LB=>LC THEN BL(5)=1
1204 VG=ABS(GB-GC):BL(4)=1:IF GB=>GC THEN BL(4)=-1
1206 LA=LC:GOSUB 2400
1208 M1=MP
1210 LA=LB:GOSUB 2400
1212 M2=MP:DM=ABS(M2-M1)
1214 IF DM=0 GOTO 1220
1216 QO=VG/(DM/60):IF QO>114.59 GOTO 1220
1218 CA=KR*ATN(QO):DR=VL*(1/COS(CA/KR)):GOTO 1222
1220 CA=90:DR=VG*COS(LC/KR)
1222 DR=DR*60:IF BL(5)=-1 GOTO 1226
1224 IF BL(4)=1 THEN CR=CA ELSE CR=360-CA
1225 RETURN
1226 IF BL(4)=1 THEN CR=180-CA ELSE CR=180+CA
1228 RETURN
1250 REM:GET WIND VECTOR FOR CURRENT ALTITUDE
1252 I=FIX(AL/4000):IF I=>10 THEN I=10
1254 WD=WA(I,0):WV=WA(I,1)
1256 RETURN
1260 REM:SOLVES WIND TRIANGLE
1262 A=CC:L=AJ:GOSUB 1300
1264 MX=LX:MY=LY
1266 GOSUB 1250
1268 A=WD+180:IF A=>360 THEN A=A-360
1270 L=WV:GOSUB 1300
1272 MX=MX+LX:MY=MY+LY:GOSUB 1350
1274 TK=MA:GS=VZ
1276 RETURN
1300 REM:RESOLVES A VECTOR INTO RECT. COORDS
1302 IF A<=90 THEN Q=1:B=90-A:GOTO 1310
1304 IF A<=180 THEN Q=2:B=A-90:GOTO 1310
1306 IF A<=270 THEN Q=3:B=270-A:GOTO 1310
1308 Q=4:B=A-270
1310 LX=L*COS(B/KR):LY=L*SIN(B/KR)
1312 IF Q=1 THEN RETURN
1314 IF Q=2 THEN LY=-1*LY:RETURN
1316 IF Q=3 THEN LX=-1*LX:LY=-1*LY:RETURN
1318 LX=-1*LX
1320 RETURN
1350 REM:COMPOSES X,Y COMPONENTS INTO A POLAR VECTOR
1352 VZ=SQR(MX^2+MY^2)
1354 IF MX<=0 GOTO 1358
1356 IF MY<=0 THEN Q=2 ELSE Q=1
1357 GOTO 1360
1358 IF MY<=0 THEN Q=3 ELSE Q=4
1360 IF MX=0 THEN MA=90:GOTO 1366
1362 MQ=ABS(MY/MX)
1364 MA=ATN(MQ)*KR
1366 IF Q=1 THEN MA=90-MA:RETURN
1368 IF Q=2 THEN MA=90+MA:RETURN
1370 IF Q=3 THEN MA=270-MA:RETURN
1372 MA=270+MA
1374 RETURN
1400 REM:GET POSITION FOR OMEGA DISPLAY
1402 ZS(2)=ZS:FA(2)=FA:CC(2)=CC:AL(2)=AL
1404 ZS=ZS(1):FA=FA(1):CC=CC(1):AL=AL(1)
1406 IF ZS(2)<>ZS OR FA(2)<>FA GOTO 1440
1408 IF CC(2)<>CC OR AL(2)<>AL GOTO 1440
1410 F(0)=1:IF TD<TW(1)+60 GOTO 1442
1412 AJ=ZS*COS(ABS(FA)/KR)
1414 GOSUB 1260
1416 DN=GS*(TD-TW(1))/3600
1418 CN=TK:L1=LL(1):G1=GL(1)
1420 GOSUB 2000
1422 F(0)=0:TW(1)=TD:LL(1)=L2:GL(1)=G2
1424 LS(1)=L2:GS(1)=G2
1426 FOR J=4 TO 7:DP(J)=CP(J):NEXT
1428 ZS(1)=ZS(2):FA(1)=FA(2):CC(1)=CC(2):AL(1)=AL(2)
1430 ZS=ZS(2):FA=FA(2):CC=CC(2):AL=AL(2)
1432 RETURN
1440 TW(1)=TD:F(0)=0
1442 AJ=ZS*COS(ABS(FA)/KR)
1444 GOSUB 1260
1446 DN=GS*TJ/3600
1448 CN=TK:L1=LS(1):G1=GS(1)
1450 GOSUB 2000
1452 LS(1)=L2:GS(1)=G2
1454 IF F(0)=1 GOTO 1458
1456 LL(1)=L2:GL(1)=G2
1458 GOTO 1426
1500 REM:VOR ROUTINE
1502 IF VO(1)=0 GOTO 1540
1504 FOR J=0 TO 15:IF VO(1)=VF(J) GOTO 1506
1505 NEXT:GOTO 1540
1506 LC=VP(J,0):GC=VP(J,1)
1508 LB=L2:GB=G2
1509 AR=VG(J,0):LL=VG(J,1)
1510 LO=360-LL
1512 GOSUB 1200
1514 IF DR>300 GOTO 1540
1516 IF CR=>360 THEN CR=CR-360
1517 GOTO 1578
1518 VO$(1)="FROM"
1519 VO(5)=CR-VO(3):IF VO(5)<=180 GOTO 1522
1520 VO(5)=VO(5)-360:GOTO 1524
1522 IF VO(5)<-180 THEN VO(5)=VO(5)+360
1524 IF ABS(VO(5))>90 THEN I1=VO(3):GOTO 1536
1526 IF VO$(1)="FROM" THEN I=-1 ELSE I=1
1527 IF I=1 THEN VO(3)=I1
1528 VO(2)=40+I*INT(VO(5)):VO(4)=DR
1530 IF VO(2)<35 THEN VO(2)=34
1532 IF VO(2)>45 THEN VO(2)=46
1534 GOTO 1560
1536 VO$(1)=" TO ":VO(3)=VO(3)+180:IF VO(3)=>360 THEN VO(3)=VO(3)-360
1538 GOTO 1519
1540 VO$(1)="OUT ":VO(4)=999.9:F(3)=0:RETURN
1546 IF DR>12 OR DR<10 THEN MK=0:GOTO 1518
1548 IF AL>4000 THEN MK=0:GOTO 1518
1550 IF F(1) =1 THEN J=9 ELSE J=2.5
1552 IF CR>AR+J OR CR<AR-J THEN MK=0:GOTO 1518
1554 F(1)=1:MK=1:GOTO 1518
1560 LOCATE 19,22:IF MK=1 THEN COLOR 0,7:PRINT"  ":COLOR 7,0:ELSE PRINT"  "
1566 IF MK=0 THEN F(1)=0:RETURN
1570 IF CC>LL+1 OR CC<LL-1 THEN RETURN
1572 IF RA<>0 THEN RETURN
1574 F(1)=0:F(2)=1
1576 GOTO 1540
1578 IF F(3)=1 THEN VO(3)=CR:F(3)=0
1580 GOTO 1546
1600 REM:ILS ROUTINE
1602 ZN=AL:TH=2.82471:MK=1
1603 DW=1.69*RW*TJ:IF F(7)=1 THEN DW=0
1604 IF F(7)=1 THEN CC=LL:RA=0
1606 CJ=CC
1608 IF CJ>180 THEN CJ=360-CJ:CJ=-1*CJ
1610 HA=LO+CJ
1612 DC=360-HA:TS=1:IF HA<180 THEN DC=HA:TS=-1
1614 IF DC<0 THEN DC=-1*DC:TS=-1*TS
1616 TL$="W":IF TS=1 THEN TL$="E"
1618 DD=1.69*ZS*TJ
1620 DY=DD*SIN(DC/KR):DX=DD*COS(DC/KR)
1622 XN=XO-DX:IF TL$="E" THEN DY=-1*DY
1624 YN=YO+DY+DW
1626 LM=KR*ATN(AL/XN)
1628 BE=KR*ATN(ABS(YN)/ABS(XN)):IF BE>2.5 THEN MK=0
1630 J=(LM-TH)/.25:J=FIX(J)
1632 IF J>3 THEN J=3
1633 IF J<-3 THEN J=-3
1636 BE=BE/.25:BE=FIX(BE)
1637 IF BE<-7 THEN BE=-7
1638 IF BE>7 THEN BE=7
1639 IF YN>0 THEN BE=-1*BE
1640 IF MK=0 GOTO 1648
1642 IF XN>34960! AND XN<38000! GOTO 1648
1644 IF XN>2534 AND XN<5574 GOTO 1648
1646 MK=0
1648 GX(1)=BE:GY(1)=J
1650 GOSUB 2100
1654 LOCATE 19,22:IF MK=1 THEN COLOR 0,7:PRINT"  ":COLOR 7,0:ELSE PRINT"  "
1662 XO=XN:YO=YN
1664 IF F8=1 GOTO 1676
1666 IF XN>12000 GOTO 1676
1668 F8=1
1670 FOR I=0 TO 3
1672 LOCATE (14+I),50:PRINT RS$(I)
1674 NEXT I
1676 IF F8=0 GOTO 1699
1678 LOCATE 18,(XQ+1):PRINT" "
1680 YU=FIX(YN/16.7):XC=64+YU
1682 IF XC<49 THEN XC=49
1684 IF XC>79 THEN XC=79
1686 LOCATE 18,(XC+1):PRINT CHR$(24)
1688 XQ=XC
1699 GOTO 1031
1700 GOTO 1799
1799 GOTO 224
1800 REM:REVERSE THRUST APPLIED
1802 IF F(4)=1 GOTO 1806
1804 VO=ZS*1.152*1.47:F(4)=1
1806 V=VO-(3.23636)*TJ
1808 IF V<=0 THEN V=0
1810 VO=V
1812 ZS=V/(1.152*1.47)
1814 RETURN
2000 REM:COMPUTES NEW POSITION
2004 IF CN=0 THEN CA=0:LB(5)=1:LB(6)=1:GOTO 2014
2006 IF CN>0 AND CN<=90 THEN CA=CN:LB(5)=1:LB(6)=1:GOTO 2014
2008 IF CN>90 AND CN<=180 THEN CA=180-CN:LB(5)=-1:LB(6)=1:GOTO 2014
2010 IF CN>180 AND CN<=270 THEN CA=CN-180:LB(5)=-1:LB(6)=-1:GOTO 2014
2012 CA=360-CN:LB(5)=1:LB(6)=-1
2014 IF CA>89.5 GOTO 2034
2016 DL=DN*COS(CA/KR):DL=DL/60:LB(3)=LB(5)
2018 IF LB(3)=1 THEN L2=L1+DL:GOTO 2024
2020 L2=ABS(L1-DL)
2024 LA=L1:GOSUB 2400
2026 M1=MP
2028 LA=L2:GOSUB 2400
2030 M2=MP
2032 DM=ABS(M1-M2):DG=DM*TAN(CA/KR):GOTO 2036
2034 L2=L1:DG=DN/COS(L1/KR)
2036 DG=DG/60:LB(4)=LB(6)
2038 IF LB(4)=-1 GOTO 2046
2040 G2=ABS(G1-DG)
2044 GOTO 2050
2046 G2=G1+DG
2050 CP(4)=FIX(L2):CP(5)=(L2-CP(4))*60
2052 CP(6)=FIX(G2):CP(7)=(G2-CP(6))*60
2054 RETURN
2100 REM:PLOT GLIDE SLOPE CROSSHAIRS
2101 IF XO<=750 THEN RETURN
2102 X0=8+GX(0):X1=8+GX(1):Y0=18+GY(0):Y1=18+GY(1)
2104 FOR Y=15 TO 21:LOCATE (Y+1),(X0+1):PRINT" ":NEXT
2106 LOCATE (Y0+1),2:PRINT STRING$(15,32)
2108 FOR Y=15 TO 21:LOCATE (Y+1),(X1+1):PRINT CHR$(197):NEXT
2110 LOCATE (Y1+1),2:PRINT STRING$(15,197)
2112 LOCATE (Y1+1),(X1+1):PRINT CHR$(43)
2114 LOCATE 19,9:PRINT"O"
2116 GX(0)=GX(1):GY(0)=GY(1)
2118 RETURN
2400 REM:COMPUTES MERIDIONAL PARTS, MP
2404 KM(0)=7915.704468#
2406 KM(1)=23.268932#
2408 KM(2)=.0525
2410 KM(3)=.000213
2414 IF LA=0 THEN LA=0+1/60
2416 IF LA>(89+59/60) THEN LA=89+59/60
2418 S1=SIN(LA/KR)
2420 S2=S1*S1:S3=S1*S2
2422 TM(0)=TAN((45+LA/2)/KR)
2424 TM(0)=KM(0)*LOG(TM(0))/LOG(10)
2426 TM(1)=KM(1)*S1
2428 TM(2)=KM(2)*S3
2430 TM(3)=KM(3)*S2*S3
2432 MP=TM(0)-TM(1)-TM(2)-TM(3)
2436 RETURN
3000 REM:ABORT ROUTINES
3002 M$(1)="---------- A CRASH HAS OCCURED ----------"
3004 M$(2)="YOU ACCIDENTLY STALLED THE AIRCRAFT DURING FINAL APPROACH."
3006 M$(3)="THE STALL OCCURRED AT AN ALTITUDE OF"
3008 M$(4)="THE AIRCRAFT STRUCK THE GROUND IN A NOSE-HIGH ATTITUDE."
3010 M$(5)="THE IMPACT RUPTURED THE TAIL SECTION OF THE FUSELAGE."
3012 M$(6)="---- LOCATION OF CRASH ----"
3013 M$(7)="---- LANDING POSITION ----"
3016 M$(8)="    PITCH ANGLE="
3018 M$(9)="    AIRSPEED="
3020 M$(10)="YOU FLARED AT TOO HIGH AN ALTITUDE DURING FINAL APPROACH."
3022 M$(11)="THE RESULTING STALL OCCURED AT AN ALTITUDE OF"
3024 M$(12)="THE IMPACT RUPTURED THE "
3026 M$(13)="YOU FORGOT TO LOWER THE LANDING GEAR."
3028 M$(14)="YOU FAILED TO TOUCH DOWN INSIDE THE RUNWAY."
3030 M$(15)="---------- AN IMPROPER LANDING WAS MADE ----------"
3032 M$(16)="NO DAMAGE OR INJURIES OCCURRED.
3033 RL=0:IF TX>100 THEN RL=1
3034 RW=0:IF ABS(TY)>100 THEN RW=1
3040 N$(2)="FEET INSIDE OF RUNWAY"
3041 IF TX=>0 THEN N$(2)="FEET SHORT OF RUNWAY"
3042 N$(3)="FEET TO LEFT OF RUNWAY CENERLINE"
3043 IF TY=>0 THEN N$(3)="FEET TO RIGHT OF RUNWAY CENTERLINE"
3044 RX=FIX(TX):RX=ABS(RX)
3045 RY=FIX(TY):RY=ABS(RY)
3050 IF AF=0 GOTO 3600
3055 ZS=INT(AX):FA=INT(FA):ZS=INT(ZS)
3060 ON AF GOTO 3100,3150,3200,3250,3300,3350,3400,3450,3500,3550
3100 GOSUB 3700
3101 YP=4:XP=55:F$="##,###":V1=AL:GOSUB 9000
3102 LOCATE 16,1:PRINT M$(1)
3104 PRINT"YOU FLEW INTO THE GROUND."
3106 PRINT"THE INSTRUMENT READINGS AT TIME OF THE CRASH ARE SHOWN AS ABOVE."
3108 END
3150 CLS
3152 PRINT M$(1)
3154 PRINT M$(2)
3156 PRINT M$(3);AX;"FEET."
3158 PRINT M$(4)
3160 PRINT M$(5)
3162 N$(1)=M$(6)
3164 GOSUB 3800
3166 END
3200 CLS
3202 PRINT M$(1)
3204 PRINT"YOU FLEW INTO THE GROUND DURING FINAL APPROACH."
3206 PRINT"AT THE TIME OF THE CRASH THE AIRCRAFT PROFILE WAS AS FOLLOWS :"
3208 PRINT M$(8);FA;"DEGREES"
3210 PRINT M$(9);ZS
3212 N$(1)=M$(6)
3214 GOSUB 3800
3216 END
3250 CLS
3252 PRINT M$(1)
3254 PRINT M$(10)
3256 PRINT M$(11);AX;"FEET."
3258 PRINT M$(12)+"FUSELAGE."
3260 N$(1)=M$(6)
3262 GOSUB 3800
3264 END
3300 CLS
3302 IF WH=10 THEN PRINT M$(1)
3304 IF WH=12 THEN PRINT"---------- A MINOR CRASH HAS OCCURRED ----------"
3306 PRINT M$(10)
3308 PRINT M$(11);AX;"FEET."
3310 IF WH=10 THEN PRINT M$(13)
3312 IF WH=10 THEN PRINT M$(12)+"FUSELAGE."
3314 IF WH=12 THEN PRINT"THE IMPACT DAMAGED THE LANDING GEAR."
3316 IF WH=12 THEN PRINT"ALL THE PASSENGERS HAVE BEEN SAFELY EVACUATED."
3318 N$(1)=M$(6)
3320 GOSUB 3800
3322 END
3350 CLS
3352 PRINT M$(1)
3354 PRINT M$(13)
3356 PRINT"THE AIRCRAFT LANDED ON ITS BELLY, CAUSING MODERATE DAMAGE."
3358 PRINT"ALL THE PASSENGERS HAVE BEEN SAFELY EVACUATED."
3360 N$(1)=M$(6)
3362 GOSUB 3800
3364 END
3400 CLS
3402 PRINT M$(15)
3404 PRINT M$(14)
3406 N$(1)=M$(7)
3408 GOSUB 3800
3410 END
3450 CLS
3452 PRINT M$(15)
3454 PRINT"YOU FAILED TO EXECUTE A FLARE PRIOR TO TOUCHING DOWN."
3456 PRINT"THIS IS A VIOLATION OF COMPANY PROCEDURES."
3458 PRINT M$(16)
3460 N$(1)=M$(7)
3462 GOSUB 3800
3464 END
3500 CLS
3502 PRINT M$(15)
3504 PRINT"YOU ROLLED OFF THE RUNWAY AFTER TOUCHING DOWN."
3506 PRINT M$(16)
3508 N$(1)=M$(7)
3512 GOSUB 3800
3513 PRINT
3514 IF XN>-9750 THEN PRINT"YOU ROLLED PAST FAR END OF RUNWAY"
3516 IF ABS(YN)>100 THEN PRINT"YOU ROLLED THROUGH RUNWAY SIDE BORDERS"
3518 END
3550 CLS
3552 PRINT"----- YOUR MISSED APPROACH SIGNAL IS ACKNOWLEDGED -----"
3554 PRINT"YOU HAVE FOLLOWED PROPER PROCEDURES."
3556 END
3600 CLS
3602 PRINT"----- YOU HAVE SUCCESSFULLY COMPLETED THE FLIGHT -----"
3604 PRINT"ALL PROCEDURES WERE PROPERLY EXECUTED."
3606 N$(1)=M$(7)
3610 PRINT"CONGRATULATIONS ON A SUCCESSFUL FLIGHT."
3612 GOSUB 3800
3613 PRINT
3614 XN=ABS(XN):JN=FIX(XN+750)
3615 YN=ABS(YN):YN=FIX(YN)
3616 PRINT"YOUR AIRCRAFT CAME TO REST AT THE FOLLOWING POSITION:"
3617 PRINT"     ";JN;"FEET INSIDE THE RUNWAY"
3618 PRINT"     ";YN;"FEET FROM RUNWAY CENTERLINE"
3620 END
3700 REM:SUBROUTINE TO CLEAR LOWER PART OF DISPLAY
3702 FOR I=9 TO 23
3704 LOCATE (I+1),1:PRINT SPC(79);
3706 NEXT I
3708 RETURN
3800 REM:LANDING STATISTICS
3802 PRINT
3804 PRINT SPACE$(26);N$(1)
3806 PRINT
3808 IF RL=0 THEN PRINT RX;N$(2)
3809 IF RL=1 THEN COLOR 0,7:PRINT RX;N$(2):COLOR 7,0
3810 PRINT
3812 IF RW=0 THEN PRINT RY;N$(3)
3813 IF RW=1 THEN COLOR 0,7:PRINT RY;N$(3):COLOR 7,0
3814 PRINT
3816 PRINT"--- SIZE OF RUNWAY IS 10,500 FEET  X  200 FEET ---"
3818 RETURN
5085 REM:TIME DELAY PAD
5090 FOR I=1 TO TQ
5095 NEXT I
5099 RETURN
7050 REM:CONVERT RTC TO TIME OF DAY IN SECONDS ABSOLUTE
7055 J=7
7060 FOR I=0 TO 2
7065 TC$(I)=MID$(TV$,J,2)
7070 J=J-3
7075 TC(I)=VAL(TC$(I))
7080 TD=(3600*TC(2))+(60*TC(1))+TC(0)
7085 NEXT I
7090 RETURN
9000 REM:PLOTS VARIABLE ON REVERSE BACKGROUND
9005 COLOR 0,7:LOCATE (YP+1),(XP+1)
9010 PRINT USING F$;V1;
9015 COLOR 7,0
9020 RETURN
9999 END
10000 REM:BEGIN TAKEOFF MODULE HERE, EH
10020 CLS:CLEAR 1000:RANDOMIZE 57.2958
10025 KR=57.2958
10030 DIM XM(13),WM(13)
10031 DIM P$(31)
10035 DATA 37,35,32,30,27,25,22,20,17,15,12,10,7,5
10040 DATA 6,11,16,21,26,31,36,41,46,51,56,61,66,71
10041 FOR I=0 TO 28:READ P$(I):NEXT
10045 FOR I=0 TO 13:READ XM(I):NEXT
10050 FOR I=0 TO 13:READ WM(I):NEXT
10055 M$(1)="_":M$(2)="_":M$(3)="_"
10060 DIM XE(13),WE(13)
10065 K1=29:K2=23
10070 FOR I=0 TO 13
10075 XE(I)=K1:WE(I)=K2
10080 K1=K1-2:K2=K2+4
10085 NEXT
10090 IO=40
10095 RN=RND(0)
10100 RS=1:IF RN>.5 THEN RS=-1
10105 W1=75:IF RS=-1 THEN W1=255
10110 W2=RND(20):W3=RS*W2
10115 DIM XL(14),XR(14)
10120 J=31:K=49
10125 FOR I=0 TO 14
10130 XL(I)=J:XR(I)=K
10135 J=J-2:K=K+2
10140 NEXT
10145 DATA FUEL,LBS,%,VHF,MHZ,THRUST,MAX,IDLE,REV
10150 DATA PITCH," +"," -",DEG,FLAPS,UP,DWN,WHEELS,UP,MID,DOWN
10155 DATA COMPASS,AIRSPEED,KTS," VERT",SPEED,FPM
10160 DATA ALTITUDE,FEET,CLOCK,BRAKE,SET,REL
10170 FOR I=0 TO 31:READ P$(I):NEXT
10175 DIM S$(25)
10180 FOR I=1 TO 25:S$(I)=SPACE$(I):NEXT
10185 FOR I=0 TO 9:F(I)=0:NEXT
10190 REM:INIT VARIABLES FOR TAKEOFF MODE
10195 FU=200000!:FP=0:CC=75:ZS=0:RC=0:AL=0
10200 MZ=107:TR=6:FL=2:FA=0:WH=13:IX=40:HY=9:BR=11:BK=11
10205 AB=0
10215 LOCATE 9,18:PRINT"AIR CANADA 312     CLEARED AS FILED"
10217 PRINT:PRINT
10218 PRINT"          SURFACE WINDS VARIABLE, GUSTING TO 15."
10219 PRINT"          MINIMUM CEILING CONDITIONS ARE IN EFFECT."
10230 PRINT"          SKY CONDITIONS AT 20,000 SCATTERED."
10235 PRINT"                         AT 30,000 BROKEN."
10240 PRINT:PRINT
10245 PRINT"UPON TAKEOFF, MAINTAIN HEADING 075 TO 3000, THEN PROCEED AS FILED."
10248 PRINT:PRINT:PRINT"        STANDBY FOR TAKEOFF CLEARANCE"
10255 TQ=7000:GOSUB 11535
10260 CLS
10265 LOCATE 11,18:PRINT"AIR CANADA 312":PRINT:PRINT
10270 PRINT"YOU ARE CLEARED FOR TAKEOFF AT 0800 HOURS"
10275 TQ=3000:GOSUB 11535
10280 CLS
10285 TIME$="07:59:00":KEY OFF:CLS
10290 TV$=TIME$:GOSUB 11555:TL=TD
10295 GOSUB 10330
10300 GOSUB 10410
10305 GOSUB 10480
10310 GOSUB 10615
10315 K$=INKEY$:IF LEN(K$)=0 GOTO 10325
10320 GOSUB 10790
10325 GOTO 10945
10330 REM:DISPLAY PANEL (HEADERS ONLY)
10335 LOCATE 1,4:PRINT P$(0);S$(4);P$(5);S$(3);P$(9);S$(3);S$(6);S$(3);P$(20)
10340 LOCATE 11,60:PRINT P$(13);S$(3);P$(16);S$(2);P$(29)
10345 LOCATE 12,62:PRINT P$(14);S$(6);P$(14);S$(6);P$(30)
10350 LOCATE 14,62:PRINT P$(15);S$(5);P$(15);S$(5);P$(31)
10352 IF F(9)=1 THEN RETURN
10355 LOCATE 2,14:PRINT P$(6);S$(6);P$(10);S$(6)
10360 LOCATE 2,69:PRINT P$(28)
10365 LOCATE 3,2:PRINT P$(1);S$(4);P$(2);S$(21);S$(3);S$(13);P$(23)
10370 LOCATE 4,23:PRINT P$(11);S$(13);P$(21);S$(2);P$(24);S$(2);P$(26)
10375 LOCATE 5,1:PRINT P$(3)
10380 LOCATE 6,40:PRINT P$(22);S$(6);P$(25);S$(5);P$(27)
10385 LOCATE 7,1:PRINT P$(4);S$(10);P$(7);S$(3);P$(12);S$(7)
10390 LOCATE 8,14:PRINT P$(8)
10395 FOR Y=1 TO 7:LOCATE (Y+1),13:PRINT CHR$(195):NEXT
10400 FOR Y=1 TO 3:LOCATE (Y+1),22:PRINT CHR$(195):NEXT
10405 RETURN
10410 REM:DISPLAY HORIZONTAL LINE
10415 IF F(9)=0 GOTO 10430
10420 LOCATE 10,1:PRINT SPACE$(80);
10425 IF HY=20 GOTO 10440
10430 LOCATE (HY+1),1:PRINT STRING$(80,"_")
10435 RETURN
10440 OH=9:HY=10
10445 FOR I=HY TO 22
10450 LOCATE (OH+1),1:PRINT SPACE$(80);
10455 LOCATE (I+1),1:PRINT STRING$(80,"_");
10460 OH=I
10465 NEXT I
10470 LOCATE 24,(IO+1):PRINT" ";
10475 RETURN
10480 REM:DISPLAY RUNWAY
10485 IF F(4)=1 GOTO 10525
10490 S=10:X=29
10495 FOR Y=10 TO 22
10500 LOCATE (Y+1),(X+1):PRINT ".";SPACE$(S);" ";SPACE$(S);".";
10505 X=X-2:S=S+2
10510 NEXT
10515 S$=S$(13)
10520 RETURN
10525 REM:PRINTS RUNWAY GRAPHICS
10530 IF N>3 GOTO 10600
10535 LOCATE (OY+1),(OX+1):PRINT SPACE$(WM);
10540 LOCATE (NY+1),(NX+1):PRINT MK$;
10545 OY=NY:OX=NX
10550 WM=FW
10555 RETURN
10560 REM:ENTRY WHEN SHIP IN FINAL ZONE
10565 LOCATE (OY+1),(OX+1):PRINT SPACE$(WM):IF F(9)=1 THEN RETURN
10570 FOR I=10 TO NY-1
10575 LOCATE (I+1),(XE(J)+1):PRINT SPACE$(WE(J))
10580 NEXT I
10585 IF N>4 THEN RETURN
10590 LOCATE (NY+1),(XY+1):PRINT MK$;
10595 RETURN
10600 IF F(2)=1 GOTO 10560 ELSE F(2)=1
10605 FOR I=10 TO 13:LOCATE (I+1),60:PRINT SPACE$(21):NEXT
10610 GOTO 10560
10615 REM:DISPLAY INSTRUMENT READINGS
10618 LOCATE 1,67:COLOR 0,7:PRINT TIME$:COLOR 7,0
10620 YP=1:XP=0:F$="######":V1=FU:GOSUB 11600
10625 YP=1:XP=7:F$="###":V1=FP:GOSUB 11600
10630 YP=1:XP=39:V1=CC:GOSUB 11600
10635 YP=4:XP=39:V1=ZS:GOSUB 11600
10640 YP=4:XP=46:F$="######":V1=RC:GOSUB 11600
10645 YP=4:XP=55:F$="##,###":V1=AL:GOSUB 11600
10650 YP=5:XP=0:F$="###":V1=MZ:GOSUB 11600
10655 REM:DISPLAY THRUST
10660 FOR I=1 TO 7
10665 LOCATE (I+1),12:PRINT" ";CHR$(195)
10670 NEXT
10675 LOCATE (TR+1),12:PRINT">"
10680 REM:DISPLAY PITCH
10685 FOR I=1 TO 3:LOCATE (I+1),21:PRINT" ";CHR$(195):NEXT
10690 LOCATE (FL+1),21:PRINT">"
10695 F$="+###"
10700 YP=5:XP=20:V1=FA:GOSUB 11600
10705 REM:DISPLAY FLAPS
10710 IF F(2)=1 GOTO 10760
10715 FOR I=11 TO 13:LOCATE (I+1),60:PRINT" ";CHR$(195):NEXT
10720 LOCATE (BR+1),60:PRINT">"
10725 REM:WHEELS
10730 FOR I=11 TO 13:LOCATE (I+1),68:PRINT" ";CHR$(195):NEXT
10735 LOCATE (WH+1),68:PRINT">"
10740 REM:BRAKES
10745 FOR I=11 TO 13:LOCATE (I+1),76:PRINT" ";CHR$(195):NEXT
10750 LOCATE (BK+1),76:PRINT">"
10760 REM:DISPLAY RUNWAY ALIGNMENT INDEX
10765 IF F(9)=1 THEN RETURN
10770 LOCATE 24,(IO+1):PRINT" ";
10775 LOCATE 24,(IX+1):PRINT CHR$(24);
10780 IO=IX
10785 RETURN
10790 REM:POLL KEY SUBROUT
10795 IF K$="F" THEN KK=1:GOTO 10820
10800 IF K$="," OR K$="." THEN KK=2:GOTO 10820
10805 IF K$="B" THEN KK=3:GOTO 10820
10810 IF K$="U" OR K$="D" THEN KK=4:GOTO 10820
10815 IF K$="L" THEN KK=5:GOTO 10820
10817 IF K$="W" THEN KK=6:GOTO 10820
10818 IF K$="S" THEN KK=7:GOTO 10820
10820 ON KK GOSUB 10830,10845,10865,10880,10925,10941,10826
10825 RETURN
10826 REM:THRUST KEY (DECREASE)
10827 IF F(7)=1 AND BR=11 THEN TR=4
10829 RETURN
10830 REM:THRUST KEY (INCREASE)
10831 IF F(7)=1 THEN RETURN
10835 F(1)=1:TR=1:RETURN
10845 REM:RUDDER KEYS
10846 IF F(7)=1 THEN RETURN
10850 IF ZS<=50 THEN RETURN
10855 IF K$="," THEN CC=CC-1 ELSE CC=CC+1
10860 RETURN
10865 REM:BRAKES
10870 IF F(0)=1 THEN RETURN
10875 F(0)=1:BK=13:RETURN
10880 REM:PITCH
10881 IF F(7)=1 THEN RETURN
10885 IF ZS<=50 THEN RETURN
10890 FD=-10:IF K$="U" THEN FD=10
10895 FA=FA+FD
10900 IF FA>60 THEN FA=60
10905 IF FA<-60 THEN FA=-60
10910 IF FA>0 THEN FL=1:RETURN
10915 IF FA=0 THEN FL=2:RETURN
10920 FL=3:RETURN
10925 REM:FLAPS
10926 IF F(7)=1 AND WH=11 THEN BR=11:RETURN
10930 IF F(3)=1 THEN RETURN
10935 IF F(3)=0 THEN F(3)=1:BR=13:RETURN
10940 RETURN
10941 REM:WHEELS
10942 IF F(7)=1 THEN WH=11
10944 RETURN
10945 REM:SITUATION UPDATE ROUTINE
10950 TV$=TIME$:GOSUB 11555:TJ=TD-TL:TL=TD
10955 IF F(9)=1 GOTO 12000
10960 IF F(0)=1 GOTO 10970
10965 GOSUB 11130:GOTO 10310
10970 IF F(4)=1 GOTO 10990
10975 F(4)=1
10980 XX=0:YY=0
10985 TD=TD:V0=0:N=1:OY=23:OX=5:WM=71
10990 REM:
10995 A=(118-18*TR)*.04028
11000 GOSUB 11190
11005 IF AL>0 GOTO 11060
11010 IF YY>10500 OR ABS(XX)>100 GOTO 11390
11015 IF FA<=0 GOTO 11100
11020 IF ZS<150 GOTO 11385
11025 IF FA>10 GOTO 11385
11030 IF F(3)=0 GOTO 11100
11035 AL=25
11040 GOSUB 11130
11045 GOSUB 11150
11050 GOSUB 11300
11055 GOTO 10305
11060 F(9)=1
11065 GOSUB 11130
11070 GOSUB 11150
11075 GOSUB 11170
11080 FOR I=10 TO 22:LOCATE (I+1),1:PRINT SPACE$(80);:NEXT
11085 HY=20
11090 GOSUB 10410
11095 GOTO 11115
11100 GOSUB 11130
11105 GOSUB 11300
11110 GOTO 10305
11115 REM:NOW DO DEPARTURE PROCEDURES
11120 GOTO 10310
11130 REM:UPDATE FUEL
11135 FU=FU-40*TJ
11140 FP=FU/3120
11145 RETURN
11150 REM:UPDATE RATE OF CLIMB
11155 RC=ZS*SIN(ABS(FA/57.3))*1.693*60
11160 IF FA<0 THEN RC=-1*RC
11165 RETURN
11170 REM:UPDATE ALT
11175 AL=AL+TJ*RC/60
11180 IF AL<=0 THEN AL=0
11185 RETURN
11190 REM:EQUATIONS OF MOTION
11195 T=TJ
11200 V=V0+A*T
11205 VB=(V+V0)/2:V0=V
11210 S=VB*T
11215 IF TD<(TX+18) GOTO 11235
11220 TX=TD
11225 WB=RS*RND(2)
11230 CC=CC+WB
11235 DA=(CC-75)/57.3
11240 DY=S*COS(ABS(DA))
11245 DX=S*SIN(ABS(DA))
11250 IF DA<0 THEN DX=-1*DX
11255 YY=YY+DY
11260 XX=XX+DX
11265 ZS=V/1.69278
11270 IF ZS>20 THEN ZS=ZS+WS
11275 IX=40+FIX(XX*7/20):IF IX>79 THEN IX=79
11280 IF IX<0 THEN IX=0
11285 ZP=FIX(YY-2500*(N-1))
11290 IF ZP>2500 THEN N=N+1:GOTO 11285
11295 RETURN
11300 REM:VARIABLES FOR RUNWAY GRAPHICS
11305 MP=FIX(10+(13*ZP)/2500)
11310 IF N>3 GOTO 11350
11315 NY=MP
11320 J=NY-10
11325 NX=XM(J)
11330 FW=WM(J)
11335 S$=SPACE$(J)
11340 MK$=M$(N)+S$(J)+"_"+S$(J)+"_"+S$(J)+"_"+S$(J)+"_"+S$(J)+"_"
11345 RETURN
11350 REM:IN ZONE 4-MARKER IS RUNWAY EDGE
11355 NY=MP
11360 J=NY-10
11365 NX=XE(J)
11370 IF N>4 THEN RETURN
11375 MK$=STRING$(WE(J),"_")
11380 RETURN
11385 AB=1:GOTO 11415
11390 AB=2:IF YY<10500 GOTO 11415
11395 FOR I=10 TO 22
11400 LOCATE (I+1),1:PRINT SPACE$(80);
11405 NEXT I
11410 GOTO 11415
11415 REM:ABORT
11420 FOR I=10 TO 22
11425 LOCATE (I+1),1:COLOR 0,7:PRINT SPACE$(80);
11430 NEXT I
11435 LOCATE 11,30:PRINT"*** TAKEOFF FAILED ***":PRINT:PRINT
11440 ON AB GOSUB 11455,11480
11445 LOCATE 20,35:COLOR 7,0:PRINT"END OF PROGRAM";
11450 END
11455 PRINT"YOU PULLED BACK ON THE STICK AT TOO SLOW A SPEED, OR YOU"
11460 PRINT"PULLED BACK THE STICK TOO FAR WHEN AT PROPER SPEED."
11465 PRINT"AS A RESULT, THE TAIL OF THE FUSELAGE SCRAPED THE RUNWAY"
11470 PRINT"AND THE AIRCRAFT SPUN OUT OF CONTROL."
11475 RETURN
11480 IF YY>10500 GOTO 11505
11485 PRINT"YOU FAILED TO STAY WITHIN THE RUNWAY BOUNDARIES."
11490 PRINT"AS A RESULT, YOU VEERED OFF THE RUNWAY AND COLLIDED WITH"
11495 PRINT" THE RUNWAY LIGHTS."
11500 RETURN
11505 PRINT" YOU RAN OUT OF RUNWAY. AS A RESULT, YOU ROLLED INTO THE"
11510 PRINT" MARSHLANDS LOCATED";FIX(YY)-10500;"FEET PAST THE END OF THE RUNWAY."
11515 IF F(3)=1 THEN RETURN
11520 PRINT:PRINT:PRINT" YOU FORGOT TO LOWER THE FLAPS."
11525 PRINT" AS A RESULT, THE AIRCRAFT COULD NOT DEVELOP SUFFICIENT LIFT."
11530 RETURN
11535 REM:TIME DELAY PAD
11540 FOR I=1 TO TQ
11545 NEXT I
11550 RETURN
11555 REM:CONVERT RTC TO TIME OF DAY IN SECONDS, ABSOLUTELY
11560 J=7
11565 FOR I=0 TO 2
11570 TC$(I)=MID$(TV$,J,2)
11575 J=J-3
11580 TC(I)=VAL(TC$(I))
11585 TD=(3600*TC(2))+(60*TC(1))+TC(0)
11590 NEXT I
11595 RETURN
11600 REM:PLOTS VARIABLE ON REVERSE BACKGROUND
11605 COLOR 0,7:LOCATE (YP+1),(XP+2)
11610 PRINT USING F$;V1;
11615 COLOR 7,0
11620 RETURN
12000 REM:DEPARTURE ROUTINE
12010 IF F(7)=1 GOTO 12025 ELSE F(7)=1
12015 GOSUB 10340
12020 F(2)=0
12025 IF WH<>11 GOTO 12040 ELSE ZS=ZS+5
12030 IF BR<>11 GOTO 12040 ELSE ZS=ZS+5
12035 IF TR=4 AND AL>1800 GOTO 24 ELSE GOTO 12090
12040 IF AL<1200 GOTO 12090
12042 LOCATE 13,1:PRINT"******** FLIGHT ABORTED **********"
12044 PRINT:PRINT
12046 PRINT"YOU FAILED TO PERFORM CRUCIAL TRIM MANOUVERS FOLLOWING LIFTOFF."
12048 PRINT" THE PROPER TRIM SEQUENCE, WHICH MUST BE COMPLETED BELOW 1200 FEET, IS AS FOLLOWS:"
12050 PRINT"   1-RAISE LANDING GEAR"
12054 PRINT"   3-REDUCE THRUST"
12055 PRINT"   2-RETRACT FLAPS"
12056 PRINT
12058 PRINT"--------------- END OF PROGRAM --------------"
12060 END
12090 GOSUB 11130
12092 GOSUB 11150
12094 GOSUB 11170
12099 GOTO 10310
13000 REM:END OF LISTING
